%% Script that generates the Linear Regression Model figure
clear,clc,close all
addpath('C:\Program Files\MATLAB\R2023b\toolbox\stats\classreg\@LinearModel\')

%% Load variables
DCT = load('../Figure 4/NALDCT_AvScores');
DCT = DCT.AvScore(:,1);
SP = load('../Figure 6/SP_AvScores');
RT1 = load('../Figure 3/RT/RTUHL_2');
RT2 = load('../Figure 3/RT/RTUHL_3');
RT = [RT1.dRT ; RT2.dRT];
clear RT1 RT2

%% Generate table
% Select Self-perceived questions most sensitive to NAL-DCT
SP_Selection = [3,6,9];
% Q3 = How much does the noise interfere with your ability to listen to the talker/s?
% Q6 = How frustrated do you feel?
% Q9 = When the talking moves from one speaker to the other, do you miss the start of what is being said?

% Build Linear Regression Model (LRM)
RT = nanmean(RT)';
SP = mean(SP.UHL(1:16,SP_Selection),2);
T = table(DCT,RT,SP,'VariableNames',{'DCT','RT','Self_Perceived'});
LRM = fitlm(T,'DCT ~ RT + Self_Perceived');

%% Generate figure
figure('PaperSize',[20 15]),hold on,box on,grid on
cmap = colormap('lines');
FS = 22;
h = plot(LRM);
set(h(1),'Marker','o','MarkerFaceColor',cmap(2,:),'MarkerSize',10,...
    'MarkerEdgeColor','w')
set(h(2),'Color','k','LineStyle','-','LineWidth',2)
set(h(3),'Color','k','LineStyle','--','LineWidth',1)
lgnd = legend(h(1),'UHL');
set(lgnd,'FontSize',FS-2,'location','NorthWest')
set(gca,'xtick',-8:0.5:-5,'Fontsize',FS-2)
set(gca,'ytick',50:10:90,'yticklabel',{'50%','60%','70%','80%','90%'},'Fontsize',FS-2)
text(-5.7,57,sprintf('Adj-R^2 = %1.2f',LRM.Rsquared.Adjusted),'Fontsize',FS-2)
text(-5.7,53,sprintf('p = %1.4f',LRM.ModelFitVsNullModel.Pvalue),'Fontsize',FS-2)
axis([-7.9 -4.5 50 90])
xlabel('RT + Self-Perceived (Q3,Q6,Q9)','Fontsize',FS)
ylabel('NAL-DCT','Fontsize',FS)
title('Linear regression model','Fontsize',FS)

orient tall
print('-dpng','-r600','Figure7')
print('-dpdf','-r600','Figure7')
close all

%% Display the LRM with normalised input data
RT = zscore(RT);    % Normalised (z-score) reaction time
SP = zscore(SP);    % Normalised (z-score) Self-Perceived survey questions
T = table(DCT,RT,SP,'VariableNames',{'DCT','RT','Self_Perceived'});
LRM = fitlm(T,'DCT ~ RT + Self_Perceived');
anova(LRM,'summary')
disp(LRM)
